/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import xeij.ComponentFactory;
import xeij.GIFAnimation;
import xeij.Keyboard;
import xeij.Mouse;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.Settings;
import xeij.TextCopy;
import xeij.XEiJ;

public class ButtonFunction {
    static final Button[] BUTTON_ARRAY = Button.values();
    static final int BUTTONS = BUTTON_ARRAY.length;
    static final Modifier[] MODIFIER_ARRAY = Modifier.values();
    static final int MODIFIERS = MODIFIER_ARRAY.length;
    static final Function[] FUNCTION_ARRAY = Function.values();
    static final int FUNCTIONS = FUNCTION_ARRAY.length;
    static final int[] assignment = new int[MODIFIERS * BUTTONS];
    public static JFrame bfnFrame;

    public static void bfnInit() {
        for (int i = 0; i < BUTTONS; ++i) {
            Button button = BUTTON_ARRAY[i];
            for (int j = 0; j < MODIFIERS; ++j) {
                Modifier modifier = MODIFIER_ARRAY[j];
                String string = modifier.paramK() + button.paramK();
                String string2 = Settings.sgsGetString(string);
                int n = Function.DONOTHING.ordinal();
                for (int k = 0; k < FUNCTIONS; ++k) {
                    Function function = FUNCTION_ARRAY[k];
                    if (!function.paramV().equals(string2)) continue;
                    n = k;
                    break;
                }
                ButtonFunction.assignment[ButtonFunction.MODIFIERS * i + j] = n;
            }
        }
        switch (Settings.sgsGetString("mousewheel")) {
            case "trace": {
                ButtonFunction.assignment[ButtonFunction.MODIFIERS * Button.WHEELUP.ordinal() + Modifier.ONLY.ordinal()] = Function.TRACE1.ordinal();
                ButtonFunction.assignment[ButtonFunction.MODIFIERS * Button.WHEELUP.ordinal() + Modifier.SHIFT.ordinal()] = Function.TRACE10.ordinal();
                ButtonFunction.assignment[ButtonFunction.MODIFIERS * Button.WHEELUP.ordinal() + Modifier.CTRL.ordinal()] = Function.TRACE100.ordinal();
                ButtonFunction.assignment[ButtonFunction.MODIFIERS * Button.WHEELDOWN.ordinal() + Modifier.ONLY.ordinal()] = Function.STEP1.ordinal();
                ButtonFunction.assignment[ButtonFunction.MODIFIERS * Button.WHEELDOWN.ordinal() + Modifier.SHIFT.ordinal()] = Function.STEP10.ordinal();
                ButtonFunction.assignment[ButtonFunction.MODIFIERS * Button.WHEELDOWN.ordinal() + Modifier.CTRL.ordinal()] = Function.STEP100.ordinal();
                ButtonFunction.assignment[ButtonFunction.MODIFIERS * Button.WHEELDOWN.ordinal() + Modifier.ALT.ordinal()] = Function.RETURN.ordinal();
                break;
            }
            case "click": {
                ButtonFunction.assignment[ButtonFunction.MODIFIERS * Button.WHEELUP.ordinal() + Modifier.ONLY.ordinal()] = Function.LEFTCLICK.ordinal();
                ButtonFunction.assignment[ButtonFunction.MODIFIERS * Button.WHEELDOWN.ordinal() + Modifier.ONLY.ordinal()] = Function.RIGHTCLICK.ordinal();
            }
        }
    }

    public static void bfnTini() {
        for (int i = 0; i < BUTTONS; ++i) {
            Button button = BUTTON_ARRAY[i];
            for (int j = 0; j < MODIFIERS; ++j) {
                Modifier modifier = MODIFIER_ARRAY[j];
                String string = modifier.paramK() + button.paramK();
                int n = assignment[MODIFIERS * i + j];
                Function function = FUNCTION_ARRAY[n];
                String string2 = function.paramV();
                Settings.sgsPutString(string, string2);
            }
        }
        Settings.sgsPutString("mousewheel", "");
    }

    public static JMenuItem bfnMakeMenuItem() {
        return Multilingual.mlnText(ComponentFactory.createMenuItem("F11/F12 and button function assignments", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonFunction.bfnOpen();
            }
        }), "ja", "F11/F12 \u304a\u3088\u3073\u30dc\u30bf\u30f3\u6a5f\u80fd\u5272\u308a\u5f53\u3066");
    }

    public static void bfnStart() {
        if (RestorableFrame.rfmGetOpened("bfn")) {
            ButtonFunction.bfnOpen();
        }
    }

    public static void bfnOpen() {
        if (bfnFrame == null) {
            ButtonFunction.bfnMakeFrame();
        }
        XEiJ.pnlExitFullScreen(false);
        bfnFrame.setVisible(true);
    }

    public static void bfnMakeFrame() {
        int n;
        int n2;
        Object object;
        int n3;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                int n2 = n / (MODIFIERS * BUTTONS);
                ButtonFunction.assignment[n -= ButtonFunction.MODIFIERS * ButtonFunction.BUTTONS * n2] = n2;
            }
        };
        int n4 = 1 + (1 + MODIFIERS) * BUTTONS;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("");
        for (n3 = 0; n3 < BUTTONS; ++n3) {
            Button button = BUTTON_ARRAY[n3];
            arrayList.add(ComponentFactory.createVerticalSeparator());
            arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel(button.en()), "ja", button.ja()));
        }
        for (n3 = 0; n3 < BUTTONS; ++n3) {
            for (int i = 0; i < MODIFIERS; ++i) {
                object = MODIFIER_ARRAY[i];
                arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel(((Modifier)((Object)object)).en()), "ja", ((Modifier)((Object)object)).ja()));
            }
        }
        ButtonGroup[] buttonGroupArray = new ButtonGroup[MODIFIERS * BUTTONS];
        for (int i = 0; i < FUNCTIONS; ++i) {
            object = FUNCTION_ARRAY[i];
            if (i == 0 || i == 6 || i == 14 || i == 16) {
                arrayList.add(ComponentFactory.createHorizontalSeparator());
            }
            arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel(((Function)((Object)object)).en()), "ja", ((Function)((Object)object)).ja()));
            for (n2 = 0; n2 < BUTTONS; ++n2) {
                arrayList.add(ComponentFactory.createVerticalSeparator());
                for (n = 0; n < MODIFIERS; ++n) {
                    int n5 = MODIFIERS * n2 + n;
                    if (i == 0) {
                        buttonGroupArray[n5] = new ButtonGroup();
                    }
                    arrayList.add(ComponentFactory.setEnabled(ComponentFactory.setText(ComponentFactory.createRadioButton(buttonGroupArray[n5], assignment[n5] == i, String.valueOf(MODIFIERS * BUTTONS * i + n5), actionListener), ""), i == Function.TEXTCOPY.ordinal() ? XEiJ.clpClipboard != null : true));
                }
            }
        }
        Object object2 = "italic";
        object = "rowSpan=2";
        for (n2 = 0; n2 < BUTTONS; ++n2) {
            object2 = (String)object2 + ";lengthen";
            for (n = 0; n < MODIFIERS; ++n) {
                object2 = (String)object2 + ";";
            }
            object = (String)object + ";rowSpan=2;colSpan=" + MODIFIERS;
        }
        bfnFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("bfn", "F11/F12 and button function assignments", null, ComponentFactory.setPreferredSize(new JScrollPane(ComponentFactory.setEmptyBorder(ComponentFactory.createGridPanel(n4, 2 + FUNCTIONS + 4, "paddingLeft=3,paddingRight=3,center", (String)object2, "italic;italic;colSpan=" + n4 + ",widen;;;;;;;colSpan=" + n4 + ",widen;;;;;;;;;colSpan=" + n4 + ",widen;;;colSpan=" + n4 + ",widen", (String)object, arrayList.toArray(new Object[0])), 6, 6, 6, 6)), 600, 380)), "ja", "F11/F12 \u304a\u3088\u3073\u30dc\u30bf\u30f3\u6a5f\u80fd\u5272\u308a\u5f53\u3066");
    }

    public static boolean bfnExecute(Button button, int n, boolean bl, Function function) {
        int n2 = n & 0x2C0;
        for (int i = 0; i < MODIFIERS; ++i) {
            Modifier modifier = MODIFIER_ARRAY[i];
            if (modifier.mask() != n2) continue;
            int n3 = button.ordinal();
            int n4 = MODIFIERS * n3 + i;
            int n5 = assignment[n4];
            Function function2 = FUNCTION_ARRAY[n5];
            if (function != null) {
                function2 = function;
            }
            return function2.execute(bl);
        }
        return false;
    }

    public static String bfnFullScreenText() {
        int n = Function.FULLSCREEN.ordinal();
        int n2 = Function.MAXIMIZED.ordinal();
        for (int i = 0; i < MODIFIERS; ++i) {
            for (int j = 0; j < BUTTONS; ++j) {
                int n3 = assignment[MODIFIERS * j + i];
                if (n3 != n && n3 != n2) continue;
                StringBuilder stringBuilder = new StringBuilder();
                if (i != 0) {
                    stringBuilder.append(MODIFIER_ARRAY[i].en()).append("+");
                }
                if (Multilingual.mlnJapanese) {
                    stringBuilder.append(BUTTON_ARRAY[j].ja());
                } else {
                    stringBuilder.append(BUTTON_ARRAY[j].en());
                }
                return stringBuilder.toString();
            }
        }
        return null;
    }

    public static enum Button {
        F11{

            @Override
            String en() {
                return "F11 key";
            }

            @Override
            String ja() {
                return "F11 \u30ad\u30fc";
            }

            @Override
            String paramK() {
                return "f11key";
            }
        }
        ,
        F12{

            @Override
            String en() {
                return "F12 key";
            }

            @Override
            String ja() {
                return "F12 \u30ad\u30fc";
            }

            @Override
            String paramK() {
                return "f12key";
            }
        }
        ,
        WHEEL{

            @Override
            String en() {
                return "Wheel button";
            }

            @Override
            String ja() {
                return "\u30db\u30a4\u30fc\u30eb\u30dc\u30bf\u30f3";
            }

            @Override
            String paramK() {
                return "wheel";
            }
        }
        ,
        WHEELUP{

            @Override
            String en() {
                return "Wheel scroll up";
            }

            @Override
            String ja() {
                return "\u30db\u30a4\u30fc\u30eb\u30b9\u30af\u30ed\u30fc\u30eb\u30a2\u30c3\u30d7";
            }

            @Override
            String paramK() {
                return "wheelup";
            }
        }
        ,
        WHEELDOWN{

            @Override
            String en() {
                return "Wheel scroll down";
            }

            @Override
            String ja() {
                return "\u30db\u30a4\u30fc\u30eb\u30b9\u30af\u30ed\u30fc\u30eb\u30c0\u30a6\u30f3";
            }

            @Override
            String paramK() {
                return "wheeldown";
            }
        }
        ,
        BUTTON4{

            @Override
            String en() {
                return "Button 4";
            }

            @Override
            String ja() {
                return "\u30dc\u30bf\u30f3 4";
            }

            @Override
            String paramK() {
                return "button4";
            }
        }
        ,
        BUTTON5{

            @Override
            String en() {
                return "Button 5";
            }

            @Override
            String ja() {
                return "\u30dc\u30bf\u30f3 5";
            }

            @Override
            String paramK() {
                return "button5";
            }
        };


        abstract String en();

        abstract String ja();

        abstract String paramK();
    }

    public static enum Modifier {
        ONLY{

            @Override
            int mask() {
                return 0;
            }

            @Override
            String paramK() {
                return "";
            }

            @Override
            String en() {
                return "Only";
            }

            @Override
            String ja() {
                return "\u5358\u72ec";
            }
        }
        ,
        SHIFT{

            @Override
            int mask() {
                return 64;
            }

            @Override
            String paramK() {
                return "shift";
            }

            @Override
            String en() {
                return "Shift";
            }

            @Override
            String ja() {
                return "Shift";
            }
        }
        ,
        CTRL{

            @Override
            int mask() {
                return 128;
            }

            @Override
            String paramK() {
                return "ctrl";
            }

            @Override
            String en() {
                return "Ctrl";
            }

            @Override
            String ja() {
                return "Ctrl";
            }
        }
        ,
        ALT{

            @Override
            int mask() {
                return 512;
            }

            @Override
            String paramK() {
                return "alt";
            }

            @Override
            String en() {
                return "Alt";
            }

            @Override
            String ja() {
                return "Alt";
            }
        };


        abstract int mask();

        abstract String paramK();

        abstract String en();

        abstract String ja();
    }

    public static enum Function {
        FULLSCREEN{

            @Override
            String en() {
                return "Toggle full screen";
            }

            @Override
            String ja() {
                return "\u5168\u753b\u9762\u8868\u793a\u306e\u5207\u308a\u66ff\u3048";
            }

            @Override
            String paramV() {
                return "fullscreen";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    XEiJ.pnlToggleFullScreen();
                }
                return true;
            }
        }
        ,
        MAXIMIZED{

            @Override
            String en() {
                return "Toggle maximized";
            }

            @Override
            String ja() {
                return "\u6700\u5927\u5316\u306e\u5207\u308a\u66ff\u3048";
            }

            @Override
            String paramV() {
                return "maximized";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    XEiJ.pnlToggleMaximized();
                }
                return true;
            }
        }
        ,
        SEAMLESS{

            @Override
            String en() {
                return "Toggle seamless mouse";
            }

            @Override
            String ja() {
                return "\u30b7\u30fc\u30e0\u30ec\u30b9\u30de\u30a6\u30b9\u306e\u5207\u308a\u66ff\u3048";
            }

            @Override
            String paramV() {
                return "seamless";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    Mouse.musSetSeamlessOn(!Mouse.musSeamlessOn);
                }
                return true;
            }
        }
        ,
        SCREENSHOT{

            @Override
            String en() {
                return "Take a screenshot";
            }

            @Override
            String ja() {
                return "\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u3092\u64ae\u308b";
            }

            @Override
            String paramV() {
                return "screenshot";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    Keyboard.kbdDoCapture();
                }
                return true;
            }
        }
        ,
        TEXTCOPY{

            @Override
            String en() {
                return "Text screen copy";
            }

            @Override
            String ja() {
                return "\u30c6\u30ad\u30b9\u30c8\u753b\u9762\u30b3\u30d4\u30fc";
            }

            @Override
            String paramV() {
                return "textcopy";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    TextCopy.txcCopy();
                }
                return true;
            }
        }
        ,
        GIFANIMATION{

            @Override
            String en() {
                return "Start recording GIF animation";
            }

            @Override
            String ja() {
                return "GIF \u30a2\u30cb\u30e1\u30fc\u30b7\u30e7\u30f3\u9332\u753b\u958b\u59cb";
            }

            @Override
            String paramV() {
                return "gifanimation";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    GIFAnimation.gifStartRecording();
                }
                return true;
            }
        }
        ,
        STOPANDSTART{

            @Override
            String en() {
                return "Stop and start";
            }

            @Override
            String ja() {
                return "\u505c\u6b62\u3068\u518d\u958b";
            }

            @Override
            String paramV() {
                return "stopandstart";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    XEiJ.mpuStopAndStart();
                }
                return true;
            }
        }
        ,
        TRACE1{

            @Override
            String en() {
                return "1 trace";
            }

            @Override
            String ja() {
                return "\u30c8\u30ec\u30fc\u30b9 1 \u56de";
            }

            @Override
            String paramV() {
                return "trace1";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    XEiJ.mpuAdvance(1);
                }
                return true;
            }
        }
        ,
        TRACE10{

            @Override
            String en() {
                return "10 traces";
            }

            @Override
            String ja() {
                return "\u30c8\u30ec\u30fc\u30b9 10 \u56de";
            }

            @Override
            String paramV() {
                return "trace10";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    XEiJ.mpuAdvance(10);
                }
                return true;
            }
        }
        ,
        TRACE100{

            @Override
            String en() {
                return "100 traces";
            }

            @Override
            String ja() {
                return "\u30c8\u30ec\u30fc\u30b9 100 \u56de";
            }

            @Override
            String paramV() {
                return "trace100";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    XEiJ.mpuAdvance(100);
                }
                return true;
            }
        }
        ,
        STEP1{

            @Override
            String en() {
                return "1 step";
            }

            @Override
            String ja() {
                return "\u30b9\u30c6\u30c3\u30d7 1 \u56de";
            }

            @Override
            String paramV() {
                return "step1";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    XEiJ.mpuStep(1);
                }
                return true;
            }
        }
        ,
        STEP10{

            @Override
            String en() {
                return "10 steps";
            }

            @Override
            String ja() {
                return "\u30b9\u30c6\u30c3\u30d7 10 \u56de";
            }

            @Override
            String paramV() {
                return "step10";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    XEiJ.mpuStep(10);
                }
                return true;
            }
        }
        ,
        STEP100{

            @Override
            String en() {
                return "100 steps";
            }

            @Override
            String ja() {
                return "\u30b9\u30c6\u30c3\u30d7 100 \u56de";
            }

            @Override
            String paramV() {
                return "step100";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    XEiJ.mpuStep(100);
                }
                return true;
            }
        }
        ,
        RETURN{

            @Override
            String en() {
                return "Step until return";
            }

            @Override
            String ja() {
                return "\u30b9\u30c6\u30c3\u30d7\u30a2\u30f3\u30c6\u30a3\u30eb\u30ea\u30bf\u30fc\u30f3";
            }

            @Override
            String paramV() {
                return "return";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    XEiJ.mpuStepUntilReturn();
                }
                return true;
            }
        }
        ,
        LEFTCLICK{

            @Override
            String en() {
                return "Left click";
            }

            @Override
            String ja() {
                return "\u5de6\u30af\u30ea\u30c3\u30af";
            }

            @Override
            String paramV() {
                return "leftclick";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    Mouse.musWheelButton = 1;
                    Mouse.musWheelReleaseTime = XEiJ.mpuClockTime + 100000000000L;
                }
                return true;
            }
        }
        ,
        RIGHTCLICK{

            @Override
            String en() {
                return "Right click";
            }

            @Override
            String ja() {
                return "\u53f3\u30af\u30ea\u30c3\u30af";
            }

            @Override
            String paramV() {
                return "rightclick";
            }

            @Override
            boolean execute(boolean bl) {
                if (bl) {
                    Mouse.musWheelButton = 2;
                    Mouse.musWheelReleaseTime = XEiJ.mpuClockTime + 100000000000L;
                }
                return true;
            }
        }
        ,
        DONOTHING{

            @Override
            String en() {
                return "No function";
            }

            @Override
            String ja() {
                return "\u6a5f\u80fd\u306a\u3057";
            }

            @Override
            String paramV() {
                return "donothing";
            }

            @Override
            boolean execute(boolean bl) {
                return false;
            }
        };


        abstract String en();

        abstract String ja();

        abstract String paramV();

        abstract boolean execute(boolean var1);
    }
}

